{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49 (0)351-8037944              =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/mmtools.html             =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 09.09.98 - 02:59:55 $                                        =}
{========================================================================}
unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, MMObj, MMCstDlg, MMHTimer, MMDIBCv, MMLevel, MMConect,
  MMDesign, MMDSPObj, MMWRec, MMUtils, MMWPlay, MMWavIn, MMWave, MMHook,
  MMACMDlg, MMRegs;

type
  TForm1 = class(TForm)
    WaveRecorder: TMMWaveRecorder;
    MMDesigner1: TMMDesigner;
    Connector: TMMConnector;
    MMLevel1: TMMLevel;
    MMLevel2: TMMLevel;
    Timer: TMMHiTimer;
    Label1: TLabel;
    SaveDialog: TMMWaveSaveDialog;
    btnFile: TButton;
    btnStop: TButton;
    btnRecord: TButton;
    btnPause: TButton;
    btnRestart: TButton;
    procedure btnFileClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure btnRecordClick(Sender: TObject);
    procedure btnStopClick(Sender: TObject);
    procedure btnPauseClick(Sender: TObject);
    procedure btnRestartClick(Sender: TObject);
    procedure WaveRecorderStart(Sender: TObject);
    procedure WaveRecorderStop(Sender: TObject);
    procedure WaveRecorderPause(Sender: TObject);
    procedure WaveRecorderRestart(Sender: TObject);
    procedure TimerTimer(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

{-- TForm1 --------------------------------------------------------------------}
procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   { stop recording at the end }
   WaveRecorder.Stop;
end;

{-- TForm1 --------------------------------------------------------------------}
procedure TForm1.btnFileClick(Sender: TObject);
begin
   if SaveDialog.Execute then
   begin
      WaveRecorder.Wave.FileName := SaveDialog.FileName;
      btnRecord.Enabled := True;
   end;
end;

{-- TForm1 --------------------------------------------------------------------}
procedure TForm1.btnRecordClick(Sender: TObject);
begin
   WaveRecorder.Recording;
end;

{-- TForm1 --------------------------------------------------------------------}
procedure TForm1.btnStopClick(Sender: TObject);
begin
   WaveRecorder.Stop;
end;

{-- TForm1 --------------------------------------------------------------------}
procedure TForm1.btnPauseClick(Sender: TObject);
begin
   WaveRecorder.Pause;
end;

{-- TForm1 --------------------------------------------------------------------}
procedure TForm1.btnRestartClick(Sender: TObject);
begin
   WaveRecorder.Restart;
end;

{-- TForm1 --------------------------------------------------------------------}
procedure TForm1.WaveRecorderStart(Sender: TObject);
begin
   Timer.Enabled     := True;
   btnRecord.Enabled := False;
   btnStop.Enabled   := True;
   btnPause.Enabled  := True;
   btnFile.Enabled   := False;
end;

{-- TForm1 --------------------------------------------------------------------}
procedure TForm1.WaveRecorderStop(Sender: TObject);
begin
   Timer.Enabled      := False;
   btnRecord.Enabled  := True;
   btnStop.Enabled    := False;
   btnPause.Enabled   := False;
   btnRestart.Enabled := False;
   btnFile.Enabled    := True;
end;

{-- TForm1 --------------------------------------------------------------------}
procedure TForm1.WaveRecorderPause(Sender: TObject);
begin
   btnPause.Enabled := False;
   btnRestart.Enabled := True;
end;

{-- TForm1 --------------------------------------------------------------------}
procedure TForm1.WaveRecorderRestart(Sender: TObject);
begin
   btnPause.Enabled := True;
   btnRestart.Enabled := False;
end;

{-- TForm1 --------------------------------------------------------------------}
procedure TForm1.TimerTimer(Sender: TObject);
begin
   Label1.Caption := TimeToString(WaveRecorder.Position);
end;

end.
